// MemSock.cpp : implementation file
//

#include "stdafx.h"
#include "..\MtomLAN\MtoMAPI.h"
#include "MSock.h"
#include "MtoMSIO\MtoMSioApi.h"
#include "MSio.h"
#include "MemSock.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// MemSock

// Async mode
void CMemSock::ASyncModeEnable()
{
	if( m_pSock )
	{
		m_pSock->ASyncModeEnable() ;
	}
}

//	Sync mode
void CMemSock::SyncModeEnable()
{
	if( m_pSock )
	{
		m_pSock->SyncModeEnable() ;
	}
}


CMemSock::CMemSock(DWORD dwProtocolType)
{
	m_dwProtocolType = dwProtocolType ;
	m_pSio = NULL ;
	m_pSock = new CMSock( this, m_dwProtocolType ) ;
}

CMemSock::~CMemSock()
{
	if( m_pSio )
	{
		delete m_pSio ;
	}
	if( m_pSock )
	{
		delete m_pSock ;
	}
}

bool CMemSock::IsEther( void )
{
	if( m_pSio )
	{
		return false ;
	}
	return true ;
}

int CMemSock::OpenMtoMLAN(LPCSTR szIPAddress)
{
	if( m_pSio )
	{
		delete m_pSio ;
		m_pSio = NULL ;
	}
	if( m_pSock == NULL )
	{
		m_pSock = new CMSock( this, m_dwProtocolType ) ;
	}
	return( m_pSock->OpenMtoMLAN( szIPAddress ) );
}
int CMemSock::OpenMtoMSio(LPMtoMSioConfig pConfig)
{
	if( m_pSock )
	{
		delete m_pSock ;
		m_pSock = NULL ;
	}
	if( m_pSio == NULL )
	{
		m_pSio = new CMSio( this, pConfig ) ;
	}
	return( m_pSio->OpenMtoMSio() );
}


int CMemSock::CloseMtoM()
{
	if( m_pSio )
	{
		return( m_pSio->CloseMtoM() );
	}
	return( m_pSock->CloseMtoM() );
}


int CMemSock::CancelMtoM()
{
	return( m_pSock->CancelMtoM() ) ;
}

int CMemSock::MtoMFS_FindNode(LPCTSTR szNetID)
{
	return( m_pSock->MtoMFS_FindNode( szNetID ) ) ;
}

int CMemSock::MtoM_ResizeGPNetWorkData(DWORD dwNodeCounter)
{
	return( m_pSock->MtoM_ResizeGPNetWorkData(dwNodeCounter)) ;
}

DWORD CMemSock::SetTransitionType(DWORD dwTranscitonType)
{
	return( m_pSock->SetTransitionType(dwTranscitonType)) ;
}

DWORD CMemSock::GetTransitionType()
{
	return( m_pSock->GetTransitionType()) ;
}

int CMemSock::MtoMESC_W(WORD wAddress,INT iDataCount,WORD* pwData)	
{
	if( m_pSio )
	{
		return( m_pSio->MtoMESC_W(wAddress,iDataCount,pwData)) ;
	}
	return( m_pSock->MtoMESC_W(wAddress,iDataCount,pwData)) ;
}

int CMemSock::MtoMESC_R(WORD wAddress,INT iDataCount,WORD* pwoData)	
{
	if( m_pSio )
	{
		return( m_pSio->MtoMESC_R(wAddress,iDataCount,pwoData)) ;
	}
	return( m_pSock->MtoMESC_R(wAddress,iDataCount,pwoData)) ;
}

int CMemSock::MtoMESC_T(GPCOLOR cDisplayColor,GPCOLOR cBackColor, INT iX1,INT iY1,GPFONTSIZE cFontSize,CHAR* szString)	
{
	if( m_pSio )
	{
		return( m_pSio->MtoMESC_T(cDisplayColor,cBackColor,iX1,iY1,cFontSize,szString)) ;
	}
	return( m_pSock->MtoMESC_T(cDisplayColor,cBackColor,iX1,iY1,cFontSize,szString)) ;
}

int CMemSock::MtoMESC_L(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iX2,INT iY2)
{
	if( m_pSio )
	{
		return( m_pSio->MtoMESC_L(cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iX2,iY2)) ;
	}
	return( m_pSock->MtoMESC_L(cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iX2,iY2)) ;
}

int CMemSock::MtoMESC_B(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iX2,INT iY2)
{
	if( m_pSio )
	{
		return( m_pSio->MtoMESC_B(cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iX2,iY2)) ;
	}
	return( m_pSock->MtoMESC_B(cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iX2,iY2)) ;
}

int CMemSock::MtoMESC_S(GPCOLOR cDisplayColor,GPCOLOR cBackColor,INT iX1,INT iY1,INT iX2,INT iY2,GPTILE cTile)
{
	if( m_pSio )
	{
		return( m_pSio->MtoMESC_S(cDisplayColor,cBackColor,iX1,iY1,iX2,iY2,cTile)) ;
	}
	return( m_pSock->MtoMESC_S(cDisplayColor,cBackColor,iX1,iY1,iX2,iY2,cTile)) ;
}

int CMemSock::MtoMESC_C(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius)
{
	if( m_pSio )
	{
		return( m_pSio->MtoMESC_C(cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iRadius)) ;
	}
	return( m_pSock->MtoMESC_C(cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iRadius)) ;
}

int CMemSock::MtoMESC_A(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius,INT iStartAngle,INT iEndAngle)
{
	if( m_pSio )
	{
		return( m_pSio->MtoMESC_A(cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iRadius,iStartAngle,iEndAngle)) ;
	}
	return( m_pSock->MtoMESC_A(cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iRadius,iStartAngle,iEndAngle)) ;
}

int CMemSock::MtoMESC_G(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius,INT iStartAngle,INT iEndAngle)
{
	if( m_pSio )
	{
		return( m_pSio->MtoMESC_G(cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iRadius,iStartAngle,iEndAngle)) ;
	}
	return( m_pSock->MtoMESC_G(cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iRadius,iStartAngle,iEndAngle)) ;
}
int CMemSock::MtoMESC_P(GPCOLOR cDisplayColor,GPCOLOR cBackColor, GPTILE cTile,GPCOLOR cLimitColor,INT iX1,INT iY1)
{
	return( m_pSock->MtoMESC_P(cDisplayColor,cBackColor,cTile,cLimitColor,iX1,iY1)) ;
}
int CMemSock::MtoMESC_I(BOOL* pbHave,DWORD *pdwCode)
{
	if( m_pSio )
	{
		return( m_pSio->MtoMESC_I(pbHave,pdwCode)) ;
	}
	return( m_pSock->MtoMESC_I(pbHave,pdwCode)) ;
}

int CMemSock::MtoMESC_t(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPFONT cFont,INT iTurn,INT iDirection,INT iHalfcentering,INT iEmphasis,GPCOLOR cSculpture,INT iX1,INT iY1,GPFONTSIZE cFontSize,CHAR* szString)
{
	if( m_pSio )
	{
		return( m_pSio->MtoMESC_t(cDisplayColor,cBackColor,cFont,iTurn,iDirection,iHalfcentering,iEmphasis,cSculpture,iX1,iY1,cFontSize,szString)) ;
	}
	return( m_pSock->MtoMESC_t(cDisplayColor,cBackColor,cFont,iTurn,iDirection,iHalfcentering,iEmphasis,cSculpture,iX1,iY1,cFontSize,szString)) ;
}

int CMemSock::MtoMESC_l(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iArrowPattern,INT iArrowDirection,INT iX1,INT iY1,INT iX2,INT iY2)
{
	if( m_pSio )
	{
		return( m_pSio->MtoMESC_l(cDisplayColor,cBackColor,cLineStyle,iArrowPattern,iArrowDirection,iX1,iY1,iX2,iY2)) ;
	}
	return( m_pSock->MtoMESC_l(cDisplayColor,cBackColor,cLineStyle,iArrowPattern,iArrowDirection,iX1,iY1,iX2,iY2)) ;
}
int CMemSock::MtoMESC_b(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iCornerDirection,INT iCornerRadius,INT iX1,INT iY1,INT iX2,INT iY2)
{
	if( m_pSio )
	{
		return( m_pSio->MtoMESC_b(cDisplayColor,cBackColor,cLineStyle,iCornerDirection,iCornerRadius,iX1,iY1,iX2,iY2)) ;
	}
	return( m_pSock->MtoMESC_b(cDisplayColor,cBackColor,cLineStyle,iCornerDirection,iCornerRadius,iX1,iY1,iX2,iY2)) ;
}
int CMemSock::MtoMESC_s(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPTILE cTile,INT iCornerDirection,INT iCornerRadius,INT iX1,INT iY1,INT iX2,INT iY2)
{
	if( m_pSio )
	{
		return( m_pSio->MtoMESC_s(cDisplayColor,cBackColor,cTile,iCornerDirection,iCornerRadius,iX1,iY1,iX2,iY2)) ;
	}
	return( m_pSock->MtoMESC_s(cDisplayColor,cBackColor,cTile,iCornerDirection,iCornerRadius,iX1,iY1,iX2,iY2)) ;
}

int CMemSock::MtoMESC_c(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPTILE cTile,INT iX1,INT iY1,INT iRadius)
{
	if( m_pSio )
	{
		return( m_pSio->MtoMESC_c(cDisplayColor,cBackColor,cTile,iX1,iY1,iRadius)) ;
	}
	return( m_pSock->MtoMESC_c(cDisplayColor,cBackColor,cTile,iX1,iY1,iRadius)) ;
}

int CMemSock::MtoMESC_g(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iX1,INT iY1,INT iRadius,INT iStartAngle,INT iEndAngle)
{
	if( m_pSio )
	{
		return( m_pSio->MtoMESC_g(cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iRadius,iStartAngle,iEndAngle)) ;
	}
	return( m_pSock->MtoMESC_g(cDisplayColor,cBackColor,cLineStyle,iX1,iY1,iRadius,iStartAngle,iEndAngle)) ;
}

int CMemSock::MtoMESC_SetContrast(DWORD dwContrast,DWORD dwLight)
{
	if( m_pSio )
	{
		return( m_pSio->MtoMESC_SetContrast(dwContrast,dwLight)) ;
	}
	return( m_pSock->MtoMESC_SetContrast(dwContrast,dwLight)) ;
}

int CMemSock::MtoMESC_GetContrast(DWORD *dwContrast,DWORD *dwLight)
{
	if( m_pSio )
	{
		return( m_pSio->MtoMESC_GetContrast(dwContrast,dwLight));
	}
	return( m_pSock->MtoMESC_GetContrast(dwContrast,dwLight));
}

int CMemSock::MtoMESC_Y(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPLINESTYLE cLineStyle,INT iPosCount,INT* piX,INT* piY)
{
	if( m_pSio )
	{
		return( m_pSio->MtoMESC_Y(cDisplayColor,cBackColor,cLineStyle,iPosCount,piX,piY) ) ;
	}
	
	return( m_pSock->MtoMESC_Y(cDisplayColor,cBackColor,cLineStyle,iPosCount,piX,piY));
}

int CMemSock::MtoMESC_y(GPCOLOR cDisplayColor,GPCOLOR cBackColor,GPTILE cTile,INT iPosCount,INT* piX,INT* piY)
{
	if( m_pSio )
	{
		return( m_pSio->MtoMESC_y(cDisplayColor,cBackColor,cTile,iPosCount,piX,piY) ) ;
	}
	
	return( m_pSock->MtoMESC_y(cDisplayColor,cBackColor,cTile,iPosCount,piX,piY));
}
	
int CMemSock::MtoMESC_M(GPCOLOR cDisplayColor,GPCOLOR cBackColor,BYTE bFontType,WORD wLanguage,BYTE bPriority,WCHAR* szString)
{
	if( m_pSio )
	{
		return( m_pSio->MtoMESC_M(cDisplayColor,cBackColor,bFontType,wLanguage,bPriority,szString) ) ;
	}
	
	return( m_pSock->MtoMESC_M(cDisplayColor,cBackColor,bFontType,wLanguage,bPriority,szString));
}

int CMemSock::MtoMESC_m(void)
{
	if( m_pSio )
	{
		return( m_pSio->MtoMESC_m() ) ;
	}
	
	return( m_pSock->MtoMESC_m());
}

DWORD CMemSock::MtoMGetLastError(void)
{
	if( m_pSio )
	{
		return( m_pSio->MtoMGetLastError()) ;
	}
	return( m_pSock->MtoMGetLastError()) ;
}
